---@meta

---@class FOpenCVArucoDetectedMarker
---@field ID int32
---@field Corners TArray<FVector2D>
---@field Pose FTransform
local FOpenCVArucoDetectedMarker = {}



---@class FOpenCVLensDistortionParametersBase
---@field K1 float
---@field K2 float
---@field P1 float
---@field P2 float
---@field K3 float
---@field K4 float
---@field K5 float
---@field K6 float
---@field F FVector2D
---@field C FVector2D
---@field bUseFisheyeModel boolean
local FOpenCVLensDistortionParametersBase = {}



---@class UOpenCVBlueprintFunctionLibrary : UBlueprintFunctionLibrary
local UOpenCVBlueprintFunctionLibrary = {}

---@param InRenderTarget UTextureRenderTarget2D
---@param InPatternSize FIntPoint
---@param bDebugDrawCorners boolean
---@param OutDebugTexture UTexture2D
---@param OutDetectedCorners TArray<FVector2D>
---@return int32
function UOpenCVBlueprintFunctionLibrary:OpenCVChessboardDetectCorners(InRenderTarget, InPatternSize, bDebugDrawCorners, OutDebugTexture, OutDetectedCorners) end
---@param InRenderTarget UTextureRenderTarget2D
---@param InDictionary EOpenCVArucoDictionary
---@param InDictionarySize EOpenCVArucoDictionarySize
---@param bDebugDrawMarkers boolean
---@param bEstimatePose boolean
---@param InMarkerLengthInMeters float
---@param InLensDistortionParameters FOpenCVLensDistortionParametersBase
---@param OutDebugTexture UTexture2D
---@param OutDetectedMarkers TArray<FOpenCVArucoDetectedMarker>
---@return int32
function UOpenCVBlueprintFunctionLibrary:OpenCVArucoDetectMarkers(InRenderTarget, InDictionary, InDictionarySize, bDebugDrawMarkers, bEstimatePose, InMarkerLengthInMeters, InLensDistortionParameters, OutDebugTexture, OutDetectedMarkers) end


